/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.items;

import fr.iglee42.evolvedmekanism.EvolvedMekanismLang;
import fr.iglee42.evolvedmekanism.blocks.BlockTieredPersonalStorage;
import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageItemContainer;
import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageManager;
import fr.iglee42.evolvedmekanism.registries.EMContainerTypes;
import fr.iglee42.evolvedmekanism.tiers.PersonalStorageTier;
import java.util.Collections;
import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.text.EnumColor;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IDroppableContents;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.util.SecurityUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class ItemBlockTieredPersonalStorage<BLOCK extends BlockTieredPersonalStorage<?, ?>>
extends ItemBlockTooltip<BLOCK>
implements IDroppableContents,
IGuiItem {
    private final ResourceLocation openStat;
    private final PersonalStorageTier tier;

    public ItemBlockTieredPersonalStorage(BLOCK block, ResourceLocation openStat, PersonalStorageTier tier) {
        super(block);
        this.openStat = openStat;
        this.tier = tier;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        return SecurityUtils.get().claimOrOpenGui(world, player, hand, (p, h, s) -> {
            if (!world.f_46443_) {
                TieredPersonalStorageManager.getInventoryFor(s);
            }
            this.getContainerType().tryOpenGui(p, h, s);
            p.m_36246_(Stats.f_12988_.m_12902_((Object)this.openStat));
        });
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        InteractionResult result = this.m_40576_(new BlockPlaceContext(context));
        Player player = context.m_43723_();
        return result.m_19077_() || player == null ? result : this.m_7203_(context.m_43725_(), player, context.m_43724_()).m_19089_();
    }

    protected boolean m_40610_(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        Player player = context.m_43723_();
        return (player == null || player instanceof FakePlayer || player.m_6144_()) && super.m_40610_(context, state);
    }

    public ContainerTypeRegistryObject<TieredPersonalStorageItemContainer> getContainerType() {
        return EMContainerTypes.TIERED_PERSONAL_STORAGE_ITEM;
    }

    public void onDestroyed(@NotNull ItemEntity item, @NotNull DamageSource damageSource) {
        super.onDestroyed(item, damageSource);
        if (!item.m_9236_().f_46443_) {
            ItemStack stack = item.m_32055_();
            TieredPersonalStorageManager.getInventoryIfPresent(stack).ifPresent(inventory -> {
                if (inventory.isInventoryEmpty()) {
                    TieredPersonalStorageManager.deleteInventory(stack);
                }
            });
        }
    }

    public List<IInventorySlot> getDroppedSlots(ItemStack stack) {
        return TieredPersonalStorageManager.getInventoryIfPresent(stack).map(inventory -> inventory.getInventorySlots(null)).orElse(Collections.emptyList());
    }

    public PersonalStorageTier getTier() {
        return this.tier;
    }

    protected void addStats(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addStats(stack, world, tooltip, flag);
        PersonalStorageTier tier = this.getTier();
        tooltip.add((Component)EvolvedMekanismLang.TIERED_STORAGE_CAPACITY.translateColored(tier.getBaseTier().getColor(), new Object[]{EnumColor.GRAY, tier.columns * tier.rows + " stacks"}));
    }
}

